# 画面設計書 158-Cat リポジトリ

## 概要

本ドキュメントは、OpenSearchのCat Repositories API（`GET /_cat/repositories`）エンドポイントに関する画面設計書である。登録されたスナップショットリポジトリの一覧をテーブル形式で返すAPIの仕様を定義する。

### 本画面の処理概要

**業務上の目的・背景**：クラスタに登録されたスナップショットリポジトリのIDとタイプを一覧形式で確認するために使用される。スナップショットの管理やバックアップ設定の確認に活用される。

**画面へのアクセス方法**：HTTPクライアントから `GET /_cat/repositories` にリクエストを送信してアクセスする。

**主要な操作・処理内容**：
1. GetRepositoriesRequestをクラスタ管理APIに発行する
2. GetRepositoriesResponseからリポジトリメタデータ一覧を取得する
3. 各リポジトリのIDとタイプをテーブルとして構築する

**画面遷移**：本APIはステートレスなREST APIである。スナップショットリポジトリAPI（`GET /_snapshot/_all`）と関連する。

**権限による表示制御**：セキュリティプラグインが有効な場合、クラスタモニタリング権限が必要となる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 109 | スナップショット | 関連機能 | スナップショットリポジトリ一覧をテーブル形式で返す処理 |

## 画面種別

一覧（テーブル形式のリポジトリ情報表示）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_cat/repositories` | リポジトリ情報をテーブル形式で返す |

## 入出力項目

### リクエストパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|------|------|-----------|------|
| format | string | No | - | レスポンス形式（json, yamlなど） |
| local | boolean | No | false | ローカル情報を返す |
| cluster_manager_timeout | time | No | 30s | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | No | 30s | **非推奨**: cluster_manager_timeoutを使用 |
| h | list | No | - | 表示するカラム名のカンマ区切りリスト |
| help | boolean | No | false | ヘルプ情報を返す |
| s | list | No | - | ソートするカラム名のカンマ区切りリスト |
| v | boolean | No | false | 冗長モード。カラムヘッダーを表示 |

## 表示項目

| カラム名 | エイリアス | 説明 | テキスト配置 |
|---------|-----------|------|-------------|
| id | repoId | リポジトリID（名前） | - |
| type | t | リポジトリタイプ（fs/s3/azure等） | 右寄せ |

## イベント仕様

### 1-GETリクエスト受信

クライアントからのGETリクエストを受信すると、`RestRepositoriesAction.doCatRequest()` が呼び出される。GetRepositoriesRequestを生成し、登録済みリポジトリ一覧を取得する。レスポンスからリポジトリメタデータを走査し、各リポジトリのIDとタイプをテーブル行として構築する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| GETリクエスト | - | SELECT | 参照のみ。データベースへの更新は発生しない |

## メッセージ仕様

| メッセージ種別 | 条件 | メッセージ内容 |
|--------------|------|-------------|
| 正常応答 | リポジトリ情報取得成功時 | テーブル形式のリポジトリ情報 |
| 正常応答 | リポジトリが0件の場合 | 空のレスポンス |

## 例外処理

- クラスタマネージャ未選出時：タイムアウトエラーが返される

## 備考

- テーブルカラムはidとtypeの2カラムのみで、Cat APIの中で最もシンプルな構造
- リポジトリの設定詳細（パス、バケット名等）は本APIでは表示されない
- typeはプラグインにより拡張可能（fs, s3, azure, gcs等）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | RepositoryMetadata.java | `server/src/main/java/org/opensearch/cluster/metadata/RepositoryMetadata.java` | name()とtype()を保持 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestRepositoriesAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestRepositoriesAction.java` | Cat Repositories APIのエントリーポイント |

**主要処理フロー**:
1. **行60-61**: `routes()` で `GET /_cat/repositories` を登録
2. **行65-81**: `doCatRequest()` でGetRepositoriesRequestを生成・発行
3. **行94-99**: `getTableWithHeader()` で2カラムのテーブルヘッダー定義
4. **行101-113**: `buildTable()` でリポジトリごとのテーブル行構築

### プログラム呼び出し階層図

```
RestRepositoriesAction.doCatRequest() [行65]
    |
    +-- GetRepositoriesRequest() [行66]
    |
    +-- client.admin().cluster().getRepositories() [行73-75]
           |
           +-- buildTable() [行101]
                  +-- getTableWithHeader() [行94]
                  +-- repositoryMetadata.name() [行106]
                  +-- repositoryMetadata.type() [行107]
```

### データフロー図

```
[入力]                     [処理]                       [出力]

GET /_cat/repositories --> RestRepositoriesAction      --> テーブル形式
                            |
                            v
                       GetRepositoriesRequest
                            |
                            v
                       GetRepositoriesResponse
                            |
                            v
                       RepositoryMetadata[] イテレート
                            |
                            v
                       buildTable() --> RestTable.buildResponse()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestRepositoriesAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestRepositoriesAction.java` | ソース | Cat Repositories APIのRESTハンドラ |
| AbstractCatAction.java | `server/src/main/java/org/opensearch/rest/action/cat/AbstractCatAction.java` | ソース | Cat API共通基底クラス |
| RepositoryMetadata.java | `server/src/main/java/org/opensearch/cluster/metadata/RepositoryMetadata.java` | ソース | リポジトリメタデータ |
| GetRepositoriesRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/repositories/get/GetRepositoriesRequest.java` | ソース | リクエストクラス |
| cat.repositories.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cat.repositories.json` | 設定 | REST API仕様定義 |
